<?php
header("Content-Type: application/json");
require_once "db_connect.php"; // include your database connection

$response = ["success" => false, "message" => "Invalid request"];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $staff_token = $_POST['staff_token'] ?? "";
    $site_token  = $_POST['site_token'] ?? "";
    $latitude    = isset($_POST['latitude']) ? (float)$_POST['latitude'] : null;
    $longitude   = isset($_POST['longitude']) ? (float)$_POST['longitude'] : null;

    // Validate required fields
    if ($staff_token === "" || $site_token === "" || $latitude === null || $longitude === null || !isset($_FILES['selfie'])) {
        echo json_encode(["success" => false, "message" => "Missing required fields"]);
        exit;
    }

    // Verify staff exists
    $stmt = $con->prepare("SELECT id FROM staff WHERE staff_token = ?");
    $stmt->bind_param("s", $staff_token);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows === 0) {
        echo json_encode(["success" => false, "message" => "Invalid staff token"]);
        exit;
    }
    $stmt->close();

    // Verify site exists
    $stmt = $con->prepare("SELECT id FROM sites WHERE site_token = ?");
    $stmt->bind_param("s", $site_token);
    $stmt->execute();
    $siteResult = $stmt->get_result();
    if ($siteResult->num_rows === 0) {
        echo json_encode(["success" => false, "message" => "Invalid site token"]);
        exit;
    }
    $stmt->close();

    // Handle selfie upload
    $uploadDir = __DIR__ . "/uploads/";
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    $fileName = uniqid("selfie_") . ".jpg";
    $targetFile = $uploadDir . $fileName;

    if (!move_uploaded_file($_FILES['selfie']['tmp_name'], $targetFile)) {
        echo json_encode(["success" => false, "message" => "Failed to upload selfie"]);
        exit;
    }

    // Toggle status (checkin/checkout)
    $status = "checkin";
    $stmt = $con->prepare("SELECT status FROM attendance WHERE staff_token = ? ORDER BY created_at DESC LIMIT 1");
    $stmt->bind_param("s", $staff_token);
    $stmt->execute();
    $lastResult = $stmt->get_result();
    if ($lastResult->num_rows > 0) {
        $lastStatus = $lastResult->fetch_assoc()['status'];
        $status = ($lastStatus === "checkin") ? "checkout" : "checkin";
    }
    $stmt->close();

    // Insert attendance record
    $stmt = $con->prepare("INSERT INTO attendance (staff_token, site_token, latitude, longitude, selfie, status) 
                           VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssddss", $staff_token, $site_token, $latitude, $longitude, $fileName, $status);

    if ($stmt->execute()) {
        $response = [
            "success" => true,
            "message" => "Attendance saved successfully",
            "staff_token" => $staff_token,
            "site_token"  => $site_token,
            "status"      => $status,
            "image_url"   => "uploads/" . $fileName
        ];
    } else {
        $response = ["success" => false, "message" => "Database error: " . $stmt->error];
    }
    $stmt->close();
}

echo json_encode($response);
