<?php
header("Content-Type: text/html; charset=utf-8");

/* -------------------------------------------
   🔌 DATABASE CONNECTION
------------------------------------------- */
$host = "localhost";        // your DB host

$user = "alinaawa_usersafeclock";        // change if different
$pass = "PO+aqa%w1Nugylpx";            // change if different
$dbname = "alinaawa_safeclock";

$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

/* -------------------------------------------
   🧭 FILTERS (By month or week)
------------------------------------------- */
$month = isset($_GET['month']) ? intval($_GET['month']) : date('n');
$week = isset($_GET['week']) ? intval($_GET['week']) : 0; // 0 = all weeks
$filterCondition = "";

if ($week > 0) {
    $filterCondition = "AND WEEK(a.date, 1) = $week";
} else {
    $filterCondition = "AND MONTH(a.date) = $month";
}

/* -------------------------------------------
   🕒 FETCH OFFICE HOURS
------------------------------------------- */
$officeQuery = $conn->query("
    SELECT TIME_TO_SEC(TIMEDIFF(time_out, time_in))/3600 AS allowed_hours
    FROM officehours LIMIT 1
");
$officeRow = $officeQuery->fetch_assoc();
$allowed_hours = $officeRow ? $officeRow['allowed_hours'] : 8;

/* -------------------------------------------
   📊 FETCH TIMESHEET DATA
------------------------------------------- */
$sql = "
    SELECT 
        s.fullname,
        s.department,
        s.email,
        a.user_token,
        a.day_of_week,
        a.date,
        MIN(CASE WHEN a.status='checkin' THEN a.time END) AS time_in,
        MAX(CASE WHEN a.status='checkout' THEN a.time END) AS time_out,
        ROUND(
            TIMESTAMPDIFF(MINUTE,
                CONCAT(a.date, ' ', MIN(CASE WHEN a.status='checkin' THEN a.time END)),
                CONCAT(a.date, ' ', MAX(CASE WHEN a.status='checkout' THEN a.time END))
            ) / 60, 2
        ) AS total_hours
    FROM attendance a
    LEFT JOIN staff s ON s.staff_token = a.user_token
    WHERE 1=1 $filterCondition
    GROUP BY a.user_token, a.date
    ORDER BY s.fullname, a.date ASC;
";

$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Staff Timesheet Report</title>
    <style>
        body {
            font-family: "Segoe UI", Arial, sans-serif;
            background: #fff;
            color: #000;
            margin: 20px;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .logo {
            width: 80px;
            height: auto;
        }
        .company-info {
            font-size: 14px;
            margin-top: 5px;
        }
        h2 {
            margin: 10px 0;
            font-size: 20px;
            text-transform: uppercase;
        }
        .filters {
            text-align: right;
            margin-bottom: 10px;
        }
        .filters form select {
            padding: 4px;
        }
        .employee-block {
            border: 1px solid #000;
            padding: 8px;
            margin-bottom: 10px;
            font-size: 14px;
            background: #f9f9f9;
        }
        table {
            border-collapse: collapse;
            width: 100%;
            font-size: 13px;
        }
        th, td {
            border: 1px solid #000;
            padding: 6px 8px;
            text-align: center;
        }
        th {
            background: #eee;
            text-transform: uppercase;
        }
        .summary-row {
            font-weight: bold;
            background: #fafafa;
        }
        .user-header {
            background: #ddd;
            font-weight: bold;
            text-align: left;
        }
        @media print {
            .filters { display: none; }
        }
    </style>
</head>
<body>

<div class="header">
    <img src="your_logo.png" class="logo" alt="Company Logo"><br>
    <div class="company-info">
        <strong>Your Company Name</strong><br>
        Address: P.O. Box 1234, Dar es Salaam<br>
        Phone: +255 700 000 000 | Email: info@company.com
    </div>
    <h2>Staff Timesheet Report</h2>
</div>

<div class="filters">
    <form method="GET">
        <label>Filter by Month: </label>
        <select name="month" onchange="this.form.submit()">
            <?php
            for ($m = 1; $m <= 12; $m++) {
                $selected = ($m == $month && $week == 0) ? "selected" : "";
                echo "<option value='$m' $selected>" . date("F", mktime(0,0,0,$m,1)) . "</option>";
            }
            ?>
        </select>
        <label>Or Week #: </label>
        <select name="week" onchange="this.form.submit()">
            <option value="0">All</option>
            <?php for ($w = 1; $w <= 52; $w++) {
                $sel = ($w == $week) ? "selected" : "";
                echo "<option value='$w' $sel>Week $w</option>";
            } ?>
        </select>
    </form>
</div>

<table>
    <tr>
        <th>Full Name</th>
        <th>Department</th>
        <th>Email</th>
        <th>Day</th>
        <th>Date</th>
        <th>Time In</th>
        <th>Time Out</th>
        <th>Total Hours</th>
        <th>Allowed Hours</th>
        <th>Overtime</th>
    </tr>

<?php
if ($result && $result->num_rows > 0) {
    $current_user = '';
    $sum_total = $sum_overtime = 0;

    while ($row = $result->fetch_assoc()) {
        $fullname = $row['fullname'] ?: 'Unknown';
        $department = $row['department'] ?: '-';
        $email = $row['email'] ?: '-';
        $total = $row['total_hours'] ?? 0;
        $overtime = max(0, $total - $allowed_hours);

        if ($current_user !== '' && $fullname !== $current_user) {
            echo "<tr class='summary-row'>
                    <td colspan='6' style='text-align:right;'>Weekly Total for $current_user</td>
                    <td>".number_format($sum_total,2)."</td>
                    <td>".number_format($allowed_hours*7,2)."</td>
                    <td>".number_format($sum_overtime,2)."</td>
                  </tr>";
            $sum_total = $sum_overtime = 0;
        }

        if ($fullname !== $current_user) {
            echo "<tr class='user-header'>
                    <td colspan='10'>
                        Employee: <b>$fullname</b> |
                        Department: <b>$department</b> |
                        Email: <b>$email</b>
                    </td>
                  </tr>";
            $current_user = $fullname;
        }

        echo "<tr>
                <td>$fullname</td>
                <td>$department</td>
                <td>$email</td>
                <td>{$row['day_of_week']}</td>
                <td>{$row['date']}</td>
                <td>{$row['time_in']}</td>
                <td>{$row['time_out']}</td>
                <td>".number_format($total,2)."</td>
                <td>".number_format($allowed_hours,2)."</td>
                <td>".number_format($overtime,2)."</td>
              </tr>";

        $sum_total += $total;
        $sum_overtime += $overtime;
    }

    echo "<tr class='summary-row'>
            <td colspan='6' style='text-align:right;'>Weekly Total for $current_user</td>
            <td>".number_format($sum_total,2)."</td>
            <td>".number_format($allowed_hours*7,2)."</td>
            <td>".number_format($sum_overtime,2)."</td>
          </tr>";

} else {
    echo "<tr><td colspan='10'>No attendance records found for this period.</td></tr>";
}
$conn->close();
?>
</table>
</body>
</html>
