<?php
header("Content-Type: text/html; charset=UTF-8");
require_once "db_connect.php";

function generateToken($length = 11) {
    $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    $token = '';
    for ($i = 0; $i < $length; $i++) {
        $token .= $chars[random_int(0, strlen($chars) - 1)];
    }
    return $token;
}

// ✅ Read POST values
$staffToken = $_POST['staff_token'] ?? "";
$userToken  = $_POST['user_token'] ?? "";
$lat        = $_POST['lat'] ?? "";
$lng        = $_POST['lng'] ?? "";
$siteToken  = $_POST['site_token'] ?? "";

if ($staffToken === "" || $userToken === "" || $lat === "" || $lng === "") {
    die("<h2 style='color:red;'>Missing required parameters</h2>");
}

// ✅ Current datetime info
date_default_timezone_set("Africa/Nairobi");
$time = date("H:i:s");
$dayOfWeek = date("l");
$weekNumber = date("W");
$month = date("F");
$date = date("Y-m-d");

// ✅ Determine checkin/checkout
$status = "checkin"; 
$stmt = $con->prepare("SELECT id, status FROM attendance WHERE user_token = ? AND date = ? ORDER BY id DESC LIMIT 1");
$stmt->bind_param("ss", $userToken, $date);
$stmt->execute();
$res = $stmt->get_result();
if ($row = $res->fetch_assoc()) {
    $status = ($row['status'] === "checkin") ? "checkout" : "checkin";
}
$stmt->close();

// ✅ Generate unique token
$attendanceToken = generateToken(11);

// ✅ Insert record
$stmt2 = $con->prepare("INSERT INTO attendance 
    (attendance_token, staff_token, user_token, latitude, longitude, status, time, day_of_week, week_number, month, date) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt2->bind_param("sssssssssss", $attendanceToken, $staffToken, $userToken, $lat, $lng, $status, $time, $dayOfWeek, $weekNumber, $month, $date);

$success = $stmt2->execute();
$stmt2->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Attendance Confirmation</title>
    <style>
        body { font-family: 'Segoe UI', sans-serif; background:#f4f7fb; margin:0; padding:20px; text-align:center; }
        .card {
            background:#fff;
            border-radius:12px;
            box-shadow:0 4px 10px rgba(0,0,0,0.1);
            padding:25px;
            margin:auto;
            max-width:500px;
        }
        h2 { color:#2c3e50; margin-bottom:10px; }
        p { margin:5px 0; color:#555; }
        .success { color:green; font-weight:bold; }
        .error { color:red; font-weight:bold; }
        .token {
            background:#1da1f2;
            color:white;
            padding:8px 12px;
            border-radius:6px;
            display:inline-block;
            margin-top:10px;
            font-weight:bold;
        }
    </style>
    <script>
        // Auto return to app after 3 seconds
        setTimeout(function(){
            window.location.href = "safeclock://closeWebView"; // custom scheme to tell app to close
        }, 3000);
    </script>
</head>
<body>
    <div class="card">
        <?php if ($success): ?>
            <h2 class="success">✅ Attendance Saved</h2>
            <p><strong>Status:</strong> <?= htmlspecialchars($status) ?></p>
            <p><strong>Time:</strong> <?= htmlspecialchars($time) ?></p>
            <p><strong>Date:</strong> <?= htmlspecialchars($date) ?> (<?= htmlspecialchars($dayOfWeek) ?>)</p>
            <p><strong>Week:</strong> <?= htmlspecialchars($weekNumber) ?> | <strong>Month:</strong> <?= htmlspecialchars($month) ?></p>
            <p class="token">Attendance ID: <?= htmlspecialchars($attendanceToken) ?></p>
            <p style="margin-top:15px;">Returning to app...</p>
        <?php else: ?>
            <h2 class="error">❌ Failed to save attendance</h2>
            <p><?= $con->error ?></p>
        <?php endif; ?>
    </div>
</body>
</html>
