<?php
require_once "config.php";
require_once "db_connect.php";
header("Content-Type: application/json");

$username = $_POST['username'] ?? '';
$device_id = $_POST['device_id'] ?? '';
$device_name = $_POST['device_name'] ?? '';

if (empty($username) || empty($device_id)) {
    echo json_encode(['status'=>'error', 'message'=>'Missing fields']);
    exit;
}

// Lookup staff
$stmt = $conn->prepare("SELECT staff_token FROM staff WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(['status'=>'error','message'=>'Username not found']);
    exit;
}

$staff = $result->fetch_assoc();
$staff_token = $staff['staff_token'];

// Insert device
$checkStmt = $conn->prepare("SELECT id FROM staff_devices WHERE device_id=?");
$checkStmt->bind_param("s", $device_id);
$checkStmt->execute();
$checkResult = $checkStmt->get_result();

if ($checkResult->num_rows > 0) {
    echo json_encode(['status'=>'error','message'=>'Device already linked']);
    exit;
}

$insertStmt = $conn->prepare("INSERT INTO staff_devices (device_id, staff_token, device_name) VALUES (?,?,?)");
$insertStmt->bind_param("sss", $device_id, $staff_token, $device_name);
if ($insertStmt->execute()) {
    echo json_encode(['status'=>'success','message'=>'Device linked']);
} else {
    echo json_encode(['status'=>'error','message'=>'Failed to link device']);
}
?>
