<?php
header("Content-Type: application/json");
require_once "db_connect.php";

$staff_token = $_POST['staff_token'] ?? '';
$site_token = $_POST['site_token'] ?? '';

if ($staff_token == '' || $site_token == '') {
    echo json_encode(["success" => false, "message" => "Missing params"]);
    exit;
}

$stmt = $con->prepare("SELECT status FROM attendance WHERE staff_token=? AND site_token=? ORDER BY id DESC LIMIT 1");
$stmt->bind_param("ss", $staff_token, $site_token);
$stmt->execute();
$res = $stmt->get_result();

if ($row = $res->fetch_assoc()) {
    echo json_encode(["success" => true, "last_status" => $row['status']]);
} else {
    echo json_encode(["success" => true, "last_status" => "checkout"]); // default
}
