<?php
header("Content-Type: application/json; charset=UTF-8");
require_once "db_connect.php";

// Default response
$response = ["success" => false, "message" => "No pending confirmations."];

// ✅ Load confirmation_hours from settings (or hardcode if needed)
$hours = 2; // fallback
$res = $con->query("SELECT value FROM settings WHERE name='confirmation_hours' LIMIT 1");
if ($res && $row = $res->fetch_assoc()) {
    $hours = (int)$row['value'];
}

// ✅ Query: Get today's attendance records that need confirmation
$sql = "
    SELECT a.id, a.user_token, s.fullname AS name, a.time
    FROM attendance a
    JOIN staff s ON a.user_token = s.staff_token
    WHERE DATE(a.date) = CURDATE()
      AND TIMESTAMPDIFF(HOUR, a.time, NOW()) >= ?
      AND a.id NOT IN (SELECT attendance_id FROM confirmations) 
    ORDER BY RAND()
    LIMIT 1
";

$stmt = $con->prepare($sql);
if (!$stmt) {
    echo json_encode(["success" => false, "message" => "DB error: " . $con->error]);
    exit;
}

$stmt->bind_param("i", $hours);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    $response["success"] = true;
    $response["data"] = [
        "id"   => $row['id'],
        "name" => $row['name'],
        "time" => $row['time']
    ];
}

echo json_encode($response);
