<?php
require_once "config.php";
require_once "db_connect.php";
header("Content-Type: application/json");

// --- Step 0: Check DB connection ---
if (!$conn) {
    die(json_encode(["status"=>"error","message"=>"Database connection failed"]));
}

// --- Step 1: Get POST data ---
$staff_token = $_POST['staff_token'] ?? '';
$device_id   = $_POST['device_id'] ?? '';
$device_name = $_POST['device_name'] ?? '';
$ssid        = $_POST['ssid'] ?? '';

if (empty($staff_token) || empty($device_id)) {
    echo json_encode(["status" => "error", "message" => "Missing required fields"]);
    exit;
}

// --- Step 2: Create devices table if not exists ---
$createTableSQL = "CREATE TABLE IF NOT EXISTS staff_devices (
    id INT AUTO_INCREMENT PRIMARY KEY,
    staff_token VARCHAR(64) NOT NULL,
    device_id VARCHAR(255) NOT NULL UNIQUE,
    ssid VARCHAR(255) DEFAULT NULL,
    device_name VARCHAR(255) DEFAULT NULL,
    registered_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

if (!$conn->query($createTableSQL)) {
    die(json_encode(["status"=>"error","message"=>"Table creation failed: ".$conn->error]));
}

// --- Step 3: Check if device already exists ---
$check = $conn->prepare("SELECT id FROM staff_devices WHERE device_id = ?");
if (!$check) {
    die(json_encode(["status"=>"error","message"=>"Prepare failed: ".$conn->error]));
}
$check->bind_param("s", $device_id);
$check->execute();
$result = $check->get_result();

if ($result->num_rows > 0) {
    echo json_encode(["status" => "exists", "message" => "Device already registered"]);
    exit;
}

// --- Step 4: Insert new device ---
$stmt = $conn->prepare("INSERT INTO staff_devices (staff_token, device_id, ssid, device_name) VALUES (?,?,?,?)");
if (!$stmt) {
    die(json_encode(["status"=>"error","message"=>"Prepare failed: ".$conn->error]));
}
$stmt->bind_param("ssss", $staff_token, $device_id, $ssid, $device_name);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Device registered successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Insert failed: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
