<?php
require_once "db_connect.php";

// -------------------
// Filters
// -------------------
$searchName = $_GET['name'] ?? '';
$searchDate = $_GET['date'] ?? date("Y-m-d");

// -------------------
// Step 1: Randomize ~60% requires_confirmation for today
// -------------------
if ($searchDate == date("Y-m-d")) {
    $res = $con->query("SELECT id FROM attendance WHERE date='$searchDate'");
    $ids = [];
    while ($r = $res->fetch_assoc()) { $ids[] = $r['id']; }

    if (!empty($ids)) {
        shuffle($ids);
        $sampleSize = ceil(count($ids) * 0.6);
        $selected = array_slice($ids, 0, $sampleSize);

        // reset then mark selected
        $con->query("UPDATE attendance SET requires_confirmation=0 WHERE date='$searchDate'");
        if (!empty($selected)) {
            $idList = implode(",", $selected);
            $con->query("UPDATE attendance SET requires_confirmation=1 WHERE id IN ($idList)");
        }
    }
}

// -------------------
// Step 2: Build Query (always join staff)
// -------------------
$sql = "SELECT a.*, s.fullname, s.department 
        FROM attendance a 
        LEFT JOIN staff s ON a.user_token = s.staff_token
        WHERE 1";
$params = [];
$types  = "";

if ($searchName != "") {
    $sql .= " AND s.fullname LIKE ?";
    $params[] = "%$searchName%";
    $types .= "s";
}

if ($searchDate != "") {
    $sql .= " AND a.date = ?";
    $params[] = $searchDate;
    $types .= "s";
}

$sql .= " ORDER BY a.date DESC, a.time DESC";

$stmt = $con->prepare($sql);
if (!$stmt) {
    die("SQL prepare failed: " . $con->error);
}
if ($params) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>📋 Attendance Records</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
    body { font-family: Arial, sans-serif; background: #fff; margin: 10px; }
    h2 { font-size: 18px; }
    form { margin-bottom: 10px; }
    input, button {
        padding: 6px 10px;
        margin: 4px;
        border-radius: 6px;
        border: 1px solid #ccc;
    }
    button { background: #1da1f2; color: white; border: none; }
    button:hover { background: #0d8ddb; }
    table { width: 100%; border-collapse: collapse; font-size: 14px; }
    th, td { padding: 6px; border: 1px solid #ddd; text-align: center; }
    th { background: #1da1f2; color: #fff; }
    tr:nth-child(even) { background: #f9f9f9; }
    .status-pending { background: #fff3cd; color: #856404; padding: 4px 6px; border-radius: 4px; }
    .status-confirmed { background: #d4edda; color: #155724; padding: 4px 6px; border-radius: 4px; }
    .status-normal { background: #e2e3e5; color: #383d41; padding: 4px 6px; border-radius: 4px; }
    .confirm-btn {
        display: inline-block;
        padding: 4px 8px;
        background: #f39c12;
        color: white;
        border-radius: 6px;
        text-decoration: none;
        font-size: 13px;
    }
</style>
</head>
<body>
<h5>📋 Attendance Records</h5>

<!-- Filter Form -->
<form method="get">
    <input type="text" name="name" placeholder="Search by name" value="<?= htmlspecialchars($searchName) ?>">
    <input type="date" name="date" value="<?= htmlspecialchars($searchDate) ?>">
    <button type="submit">Search</button>
    <a href="admin_attendance.php"><button type="button">Reset</button></a>
</form>

<table>
    <tr>
        <th>Full Name</th>
        <th>Department</th>
        <th>Status</th>
        <th>Date</th>
        <th>Time</th>
        <th>Day</th>
        <th>Action</th>
    </tr>
    <?php if ($result->num_rows > 0): ?>
        <?php while($row = $result->fetch_assoc()) { ?>
        <tr>
            <td><?= htmlspecialchars($row['fullname'] ?? 'Unknown') ?></td>
            <td><?= htmlspecialchars($row['department'] ?? '-') ?></td>
            <td>
                <?php if ($row['requires_confirmation'] == 1): ?>
                    <span class="status-pending">Pending</span>
                <?php else: ?>
                    <span class="status-normal"><?= htmlspecialchars($row['status']) ?></span>
                <?php endif; ?>
            </td>
            <td><?= htmlspecialchars($row['date']) ?></td>
            <td><?= htmlspecialchars($row['time']) ?></td>
            <td><?= htmlspecialchars($row['day_of_week']) ?></td>
            <td>
                <?php if ($row['requires_confirmation'] > 0): ?>
                    <a href="confirm_selfie.php?staff_token=<?= urlencode($row['staff_token']) ?>&attendance_token=<?= urlencode($row['attendance_token']) ?>&lat=<?= urlencode($row['latitude']) ?>&lng=<?= urlencode($row['longitude']) ?>" 
                       class="confirm-btn">Confirm</a>
                <?php else: ?>
                    ✅
                <?php endif; ?>
            </td>
        </tr>
        <?php } ?>
    <?php else: ?>
        <tr><td colspan="7">No records found.</td></tr>
    <?php endif; ?>
</table>
</body>
</html>